Module TiposDatos
    Public Structure Velocidad
        Public PosX As Decimal
        Public PosY As Decimal
    End Structure
  
    Public Structure Pajaros
        Public X1 As Decimal
        Public Y1 As Decimal
        Public X2 As Decimal
        Public Y2 As Decimal
        Public Colour As Int16
        Public Stress As Int16
        Public Vecinos As Integer()
        Public Direccion As Int16
        Public Propuesta As Int16
        Public Fijo As Int16
    End Structure

    Public Structure Ciclo
        Public C1 As Int16
        Public C2 As Int16
        Public C3 As Int16
        Public C4 As Int16
        Public C5 As Int16
        Public C6 As Int16
        Public C7 As Int16
        Public C8 As Int16
    End Structure

    Public Structure PSO
        Public pso_cola As Int16
        Public pso_coll As Int16
        Public pso_colg As Int16
        Public pso_vala As Int16
        Public pso_vall As Int16
        Public pso_valg As Int16
        Public pso_prob As Decimal
    End Structure

    Public lListaTabu As String()
    Public lMetas As Velocidad()
    Public lEnemigos As Velocidad()
    Public lBirds As Pajaros()
    Public lBrelazB As Pajaros()
    Public lCiclo As Ciclo()
    Dim enemigos As Int16()
    Dim aco(,) As Int16
    Public mundox, mundoy As Int16
    Public colores As Int16
    Public boids As Int16
    Public metacuad As Decimal
    Public rmeta As Decimal
    Public confort As Int16
    Public especial As Boolean
    Public clique As String
    Dim Random As New Random()


    Public Sub CalculoPos(ByVal pajaro As Int16, ByVal bool As Boolean, ByVal colorsal As Int16, ByVal nuecolor As Int16)

        Dim auxX1, auxY1 As Decimal

        auxX1 = Random.Next(1, mundox)
        auxY1 = Random.Next(1, mundoy)

        If bool Then
            colorsal = Random.Next(0, colores)
            lBirds(pajaro).Direccion = colorsal
            If Distancia(lMetas(colorsal).PosX, auxX1, lMetas(colorsal).PosY, auxY1) = True Then
                lBirds(pajaro).Colour = colorsal
            End If
        Else
            'auxX1 = mundox / 2  ' Coloca X en el centro
            'auxY1 = mundoy / 2  ' Coloca Y en el centro
            colorsal = lBirds(pajaro).Direccion
            nuecolor = Random.Next(0, colores) ' Asignar color no permitir blancos
            lBirds(pajaro).Propuesta = nuecolor

        End If

        lBirds(pajaro).X1 = auxX1
        lBirds(pajaro).Y1 = auxY1
        lBirds(pajaro).X2 = auxX1
        lBirds(pajaro).Y2 = auxY1
        lBirds(pajaro).Stress = 0  ' Satisfaccin
    End Sub
    Public Function Distancia(ByVal x1 As Decimal, ByVal x2 As Decimal, ByVal y1 As Decimal, ByVal y2 As Decimal) As Boolean
        Dim dist, distx, disty As Decimal
        distx = x1 - x2
        disty = y1 - y2
        dist = (distx ^ 2) + (disty ^ 2)
        If (dist < metacuad) Then
            Return True
        Else
            Return False
        End If
    End Function
    Public Sub ColocarMetas()
        Dim i As Int16
        Dim radio, angulo1, angulo2 As Decimal
        radio = mundox / 3
        angulo1 = 360 / colores
        angulo2 = 360
        For i = 0 To colores - 1
            angulo2 = angulo2 - angulo1
            lMetas(i).PosX = (radio * Math.Sin(angulo2 * 2 * Math.PI / 360)) + 50
            lMetas(i).PosY = (radio * Math.Cos(angulo2 * 2 * Math.PI / 360)) + 50
        Next
    End Sub
    Public Function Resuelto() As Int16
        Dim i, j, color As Int16

        For i = 0 To boids - 1
            color = lBirds(i).Colour
            If color = 999 Then Return 1
            For j = i + 1 To boids - 1
                If lBirds(i).Vecinos(j) < 0 Then
                    If color = lBirds(j).Colour Then
                        Return 1
                    End If
                End If
            Next
        Next
        Return 0
    End Function
    Public Function EvitaCiclos(ByVal pajaro As Int16, ByVal nuevo As Int16) As Int16
        Dim vuelta As Int16
        lCiclo(pajaro).C8 = lCiclo(pajaro).C7
        lCiclo(pajaro).C7 = lCiclo(pajaro).C6
        lCiclo(pajaro).C6 = lCiclo(pajaro).C5
        lCiclo(pajaro).C5 = lCiclo(pajaro).C4
        lCiclo(pajaro).C4 = lCiclo(pajaro).C3
        lCiclo(pajaro).C3 = lCiclo(pajaro).C2
        lCiclo(pajaro).C2 = lCiclo(pajaro).C1
        lCiclo(pajaro).C1 = nuevo

        vuelta = nuevo
        If (lCiclo(pajaro).C1 = lCiclo(pajaro).C2) And (lCiclo(pajaro).C1 = lCiclo(pajaro).C3) Then
            Return nuevo
        End If

        If (lCiclo(pajaro).C1 = lCiclo(pajaro).C3) And (lCiclo(pajaro).C1 = lCiclo(pajaro).C5) And _
           (lCiclo(pajaro).C1 = lCiclo(pajaro).C7) And (lCiclo(pajaro).C2 = lCiclo(pajaro).C4) And _
           (lCiclo(pajaro).C2 = lCiclo(pajaro).C6) And (lCiclo(pajaro).C2 = lCiclo(pajaro).C8) Then
            CalculoPos(pajaro, False, 0, vuelta)
        End If

        lCiclo(pajaro).C1 = vuelta
        Return vuelta

    End Function
    Public Sub AtraccionMeta(ByVal pajaro As Int16)
        Dim i, j, k, color, color2, colorant, ataque, enemig, selenemig As Int16
        Dim auxX, auxY, posX, posY, metX, metY, dist1, dist2 As Decimal
        Dim correr As Decimal
        Dim normaX, normaY, norma As Decimal
        Dim stress, expulsado, orden, colorreal As Int16
        Dim lCerca As Velocidad()
        ReDim lCerca(colores - 1)

        If lBirds(pajaro).Propuesta <> 999 Then
            Exit Sub
        End If
        posX = lBirds(pajaro).X1
        posY = lBirds(pajaro).Y1
        colorant = lBirds(pajaro).Direccion
        colorreal = lBirds(pajaro).Colour
        metX = lMetas(colorant).PosX
        metY = lMetas(colorant).PosY
        metX = metX - posX
        metY = metY - posY
        dist1 = (metX ^ 2) + (metY ^ 2)
        dist2 = Math.Sqrt(dist1)

        If colorreal = 999 Then
            normaX = (metX * (mundox - dist2))
            normaY = (metY * (mundoy - dist2))
            norma = ((normaX ^ 2) + (normaY ^ 2))
            norma = Math.Sqrt(norma)

            If norma = 0 Then
                norma = 1
            End If

            If dist2 > rmeta Then
                correr = rmeta / 4
            Else
                correr = rmeta / 5
            End If

            auxX = posX + (normaX / norma)
            auxY = posY + (normaY / norma)
            If normaX > 0 Then
                auxX = auxX + correr
            Else
                auxX = auxX - correr '  Si no tiene color les hago correr mas
            End If
            If normaY > 0 Then
                auxY = auxY + correr
            Else
                auxY = auxY - correr  ' Si no tiene color les hago correr mas
            End If
            lBirds(pajaro).X2 = auxX
            lBirds(pajaro).Y2 = auxY
            lBirds(pajaro).Stress = 0
            Exit Sub
        End If

        ' Si tiene color
        lCerca(0).PosX = colorant
        lCerca(0).PosY = dist2

        ' Calculo la dintancia a las metas
        Dim colaux As Int16
        orden = 0
        For i = 0 To colores - 1
            If i = colorant Then
                Continue For
            End If
            orden = orden + 1
            metX = lMetas(i).PosX
            metY = lMetas(i).PosY
            metX = metX - posX
            metY = metY - posY
            dist1 = (metX ^ 2) + (metY ^ 2)
            dist1 = Math.Sqrt(dist1)
            colaux = 0
            ' Ordeno las metas de mas cercana a mas lejana pero sin tener en cuenta la direccion actual
            ' Da igual la distancia de la direccon actual, prima sobre las demas metas
            If orden = 1 Then
                lCerca(orden).PosX = i
                lCerca(orden).PosY = dist1
            Else
                For j = 1 To orden - 1
                    If lCerca(j).PosY > dist1 Then
                        For k = orden To j + 1 Step -1
                            auxX = lCerca(k - 1).PosX
                            auxY = lCerca(k - 1).PosY
                            lCerca(k).PosX = auxX
                            lCerca(k).PosY = auxY
                        Next
                        lCerca(j).PosX = i
                        lCerca(j).PosY = dist1
                        colaux = 999
                        Exit For
                    End If
                Next
                If colaux < 999 Then
                    lCerca(orden).PosX = i
                    lCerca(orden).PosY = dist1
                End If
            End If
        Next

        ataque = 0
        enemig = 0


        '    buscar enemigos en mi meta
        For j = 0 To colores - 1

            color = lCerca(j).PosX

            For i = 0 To boids - 1
                If pajaro = i Then
                    Continue For
                End If
                color2 = lBirds(i).Colour  ' Solo cuento boids que han llegado a una meta
                If color2 = 999 Then
                    Continue For
                End If
                If color2 = color Then

                    ' si hay un enemigo en la meta objetivo lo marco y sigo buscando metas disponibles
                    If lBirds(pajaro).Vecinos(i) < 0 Then  ' Enemigo

                        enemig = enemig + 1
                        lEnemigos(enemig).PosX = i
                        ataque = color
                        Exit For
                    End If
                End If
            Next


            ' Si no se ha producido un ataque es que el color puede usarse y me encamino hacia el
            If ataque <> color Then

                ' Para evitar los ciclos
                color = EvitaCiclos(pajaro, color)
                ' Si mi color es el actual incremento mi Confort
                If colorreal = color Then

                    lBirds(pajaro).X2 = posX
                    lBirds(pajaro).Y2 = posY
                    stress = lBirds(pajaro).Stress
                    If stress < confort Then
                        lBirds(pajaro).Stress = stress + 1
                    End If
                    Exit Sub
                End If

                ' Si mi color no es el actual me dirijo hacia el nuevo color
                dist1 = lCerca(j).PosY
                lBirds(pajaro).Propuesta = color
                ' Directo a meta
                normaX = ((lMetas(color).PosX - posX) * (mundox - dist1))
                normaY = ((lMetas(color).PosY - posY) * (mundoy - dist1))
                norma = ((normaX ^ 2) + (normaY ^ 2))

                norma = Math.Sqrt(norma)
                If norma = 0 Then
                    norma = 1
                End If
                lBirds(pajaro).X2 = posX + (normaX / norma)
                lBirds(pajaro).Y2 = posY + (normaY / norma)
                stress = lBirds(pajaro).Stress
                If stress < confort Then
                    If colorant = color Then
                        lBirds(pajaro).Stress = stress + 1
                    Else
                        lBirds(pajaro).Stress = 0
                    End If
                    Exit Sub
                End If
            End If
        Next

        If enemig = 0 Then
            CalculoPos(pajaro, True, 0, 0) ' Decolora a un enemigo
            Exit Sub
        End If

        ' Selecciono el enemigo a expulsar
        If enemig = 1 Then
            selenemig = 1
        Else
            selenemig = Random.Next(0, enemig)
        End If

        expulsado = lEnemigos(selenemig).PosX
        stress = lBirds(expulsado).Stress
        If stress > 0 Then
            lBirds(expulsado).Stress = stress - 1
        Else
            CalculoPos(expulsado, False, colorant, 0) ' Decolora a un enemigo
            For i = 0 To boids - 1
                If i = expulsado Then
                    Continue For
                End If
                If especial Then
                    If lBirds(i).Colour = colorant And lBirds(i).Vecinos(pajaro) < 0 Then
                        lBirds(i).Stress = 0
                    End If
                End If
            Next
        End If

        ' Directo a meta
        normaX = ((lMetas(colorant).PosX - posX) * (mundox - dist2))
        normaY = ((lMetas(colorant).PosY - posY) * (mundoy - dist2))
        norma = ((normaX ^ 2) + (normaY ^ 2))
        norma = Math.Sqrt(norma)
        If norma = 0 Then
            norma = 1
        End If
        lBirds(pajaro).X2 = posX + (normaX / norma)
        lBirds(pajaro).Y2 = posY + (normaY / norma)

    End Sub

    Public Function AntColony(ByVal it As Double, ByVal cota As Int16, ByRef antz As Integer)
        Dim hormigas As Double
        Dim i, j, enemi, Color As Int16
        ReDim aco(boids - 1, boids - 1)
        ReDim enemigos(boids - 1)

        For i = 0 To boids - 1
            lBirds(i).Colour = 999
            lBirds(i).Stress = cota
            lBirds(i).Fijo = 0
            For j = 0 To boids - 1
                If j < cota Then
                    aco(i, j) = j
                Else
                    aco(i, j) = 999
                End If
            Next
        Next

        antz = cota * boids

        Dim coloraux As Int16

        For hormigas = 1 To it
            ' Para cada uno de los boids
            If (hormigas Mod 5000) = 0 Then
                enemi = 0
            End If
            'Regenerar Hormigas
            For i = 0 To boids - 1
                If lBirds(i).Stress = 0 Then
                    lBirds(i).Stress = cota
                    antz = antz + cota

                    For j = 0 To cota - 1
                        aco(i, j) = j
                    Next
                End If
            Next

            For i = 0 To boids - 1
                enemi = 0
                Select Case lBirds(i).Fijo
                    Case 2
                        coloraux = lBirds(i).Colour
                        While True
                            Color = Random.Next(0, cota)
                            If Color <> coloraux Then
                                Exit While
                            End If
                        End While
                        enemi = moverhormigas(i, Color)
                        traerhromigas(i, Color, enemi)
                        enemi = fijar(i)
                    Case 1
                        ' Ya tiene color
                        Color = lBirds(i).Colour
                        enemi = moverhormigas(i, Color)
                        traerhromigas(i, Color, enemi)
                        enemi = fijar(i)
                    Case 0
                        ' no tiene color todavia
                        enemi = fijar(i)
                        enemi = moverhormigas(i, enemi)
                        traerhromigas(i, Color, enemi)
                End Select
                Continue For
            Next
            If Resuelto() = 0 Then
                Return hormigas
            End If
        Next
        Return hormigas

    End Function
    Private Function moverhormigas(ByVal origen As Int16, ByVal color As Int16)
        Dim j, k, l, enemi As Int16
        ' obtener enemigos
        For j = 0 To boids - 1
            If j = origen Then
                Continue For
            End If
            If lBirds(origen).Vecinos(j) < 0 Then
                enemigos(enemi) = j
                enemi = enemi + 1
            End If
        Next
        If enemi > boids Then
            enemi = boids
        End If
        For j = 0 To enemi - 1
            For k = 0 To boids - 1
                If aco(origen, k) <> color And aco(origen, k) <> 999 Then
                    For l = 0 To boids - 1
                        If aco(enemigos(j), l) = 999 Then
                            aco(enemigos(j), l) = aco(origen, k)
                            aco(origen, k) = 999
                            lBirds(enemigos(j)).Stress += 1
                            lBirds(origen).Stress -= 1
                            Exit For
                        End If
                    Next
                    Exit For
                End If
            Next
        Next
        Return enemi
    End Function
    Private Sub traerhromigas(ByVal origen, ByVal color, ByVal enemi)
        Dim j, k, l As Int16
        For j = 0 To enemi - 1
            For k = 0 To boids - 1
                If aco(enemigos(j), k) = color And color <> 999 Then
                    For l = 0 To boids - 1
                        If aco(origen, l) = 999 Then
                            aco(origen, l) = color
                            aco(enemigos(j), k) = 999
                            lBirds(origen).Stress += 1
                            lBirds(enemigos(j)).Stress -= 1
                            Exit For
                        End If
                    Next
                    'Exit For ' Traigo todos
                End If
            Next
        Next

    End Sub
    Private Function fijar(ByVal origen As Int16)
        Dim j, max, enemi, fijo As Int16
        Dim totcolor As Int16()
        ReDim totcolor(boids - 1)

        For j = 0 To boids - 1
            If aco(origen, j) = 999 Then
                Continue For
            End If
            totcolor(aco(origen, j)) = totcolor(aco(origen, j)) + 1
        Next
        max = 0
        For j = 0 To boids - 1
            If totcolor(j) >= max Then
                If totcolor(j) = max Then
                    fijo = 0
                Else
                    fijo = 1
                    max = totcolor(j)
                    enemi = j
                End If
            End If
        Next

        For j = 0 To boids - 1
            If j = origen Then
                Continue For
            End If
            If lBirds(origen).Vecinos(j) < 0 Then
                If lBirds(j).Colour = enemi Then
                    fijo = 2
                End If
            End If
        Next

        lBirds(origen).Colour = enemi
        lBirds(origen).Fijo = fijo

        Return enemi
    End Function

    Public Function backtrack_algorithm(ByVal it As Integer) As Double
        Dim i, j, k, l, find, posback As Int16
        Dim back As Double

        For i = 0 To boids - 1
            lBrelazB(i).X1 = 999
            lBirds(i).Propuesta = i
            For j = 0 To colores - 1
                lBrelazB(i).Vecinos(j) = j
            Next
        Next

        back = 0
        While True
            back = back + 1

            For i = 0 To boids - 1 ' for 1
                If lBrelazB(i).X1 <> 999 Then
                    Continue For
                End If

                find = 0
                For j = 0 To colores - 1  ' for2
                    If (lBrelazB(i).Vecinos(j) <> 999) Then
                        lBrelazB(i).Vecinos(j) = 999
                        If (ColorValido(i, j) = 0) Then
                            lBrelazB(i).X1 = j
                            find = 1
                            Exit For
                        End If
                    End If
                Next  ' fin for 2

                If find = 0 Then
                    posback = 1
                    While True
                        If lBrelazB(i - posback).Vecinos(colores - 1) = 999 Then
                            posback = posback + 1
                            If posback > i Then
                                back = it
                                Return back
                            End If
                        Else
                            Exit While
                        End If
                    End While

                    For j = 0 To posback - 1
                        For k = 0 To colores - 1  ' for 3
                            If (lBrelazB(i - j - 1).Vecinos(k) = lBrelazB(i - j - 1).X1) Then
                                lBrelazB(i - j - 1).Vecinos(k) = 999
                                Exit For
                            End If
                        Next ' fin for 3
                        lBrelazB(i - j - 1).X1 = 999
                        For l = 0 To colores - 1 ' Rehace el siguiente con los valores de los colores
                            lBrelazB(i - j).Vecinos(l) = l
                        Next
                    Next
                    Exit For
                End If
            Next ' fin for 1

            If lBrelazB(boids - 1).X1 <> 999 Then
                Exit While
            End If
            If back >= it Then
                Exit While
            End If
        End While ' fin while

        Return back

    End Function
    Private Function ColorValido(ByVal nodo As Int16, ByVal Color As Int16) As Int16
        Dim i As Int16
        Dim nodoreal, nodocol As Int16

        For i = 1 To boids - 1
            If lBirds(i).Propuesta = nodo Then
                nodoreal = i
            End If
        Next
        'sudo if anteriores == 0 then return 0;
        ' sudo for i = 1 to anteriores do
        For i = 0 To boids - 1
            If lBirds(nodoreal).Vecinos(i) < 0 Then
                nodocol = lBirds(i).Propuesta
                If lBrelazB(nodocol).X1 = Color Then
                    Return 1
                End If
            End If
        Next

        Return 0
    End Function
    Public Function dsatur_algorithm(ByVal it As Integer) As Double
        Dim i, j, k, l, find, posback, numcli As Int16
        Dim back As Double
        Dim nodos, cliaux As String
        Dim lBrelazAux As Pajaros()

        ReDim lBrelazAux(boids - 1)

        nodos = "0"
        For i = 1 To boids - 1
            nodos = nodos + " " + CStr(i)
        Next

        clique = 1
        clique = Bronkerbosch(nodos)

        numcli = NumWords(clique)

        If numcli > colores Then
            MessageBox.Show("Impossible to find a solution wiht the number of colors given", "Brelaz", MessageBoxButtons.OK)
            Exit Function
        End If

        For i = 0 To boids - 1
            lBrelazB(i).X1 = 999
            For j = 0 To colores - 1
                lBrelazB(i).Vecinos(j) = j
            Next
        Next

        cliaux = ""
        For i = 0 To numcli - 1
            cliaux = GetWord(clique, i)
            lBrelazB(cliaux).X1 = i
            lBrelazB(cliaux).Vecinos(i) = 999
            lBrelazB(cliaux).Colour = 1
        Next

        Dim neworden As Int16
        neworden = 0
        For i = 0 To boids - 1 ' pongo primero los del clique
            If lBrelazB(i).Colour = 1 Then
                lBrelazAux(neworden) = lBrelazB(i)
                lBirds(i).Propuesta = neworden
                neworden = neworden + 1
            End If
        Next
        For i = 0 To boids - 1 ' guardo el resto
            If lBrelazB(i).Colour <> 1 Then
                lBrelazAux(neworden) = lBrelazB(i)
                lBirds(i).Propuesta = neworden
                neworden = neworden + 1
            End If
        Next

        lBrelazB = lBrelazAux

        back = 0
        While True
            back = back + 1

            For i = numcli To boids - 1 ' for 1
                If lBrelazB(i).X1 <> 999 Then
                    Continue For
                End If

                find = 0
                For j = 0 To colores - 1  ' for2
                    If (lBrelazB(i).Vecinos(j) <> 999) Then
                        lBrelazB(i).Vecinos(j) = 999
                        If (ColorValido(i, j) = 0) Then
                            lBrelazB(i).X1 = j
                            find = 1
                            Exit For
                        End If
                    End If
                Next  ' fin for 2

                If find = 0 Then
                    posback = 1
                    While True
                        If lBrelazB(i - posback).Vecinos(colores - 1) = 999 Then
                            posback = posback + 1
                        Else
                            Exit While
                        End If
                    End While

                    For j = 0 To posback - 1
                        For k = 0 To colores - 1  ' for 3
                            If (lBrelazB(i - j - 1).Vecinos(k) = lBrelazB(i - j - 1).X1) Then
                                lBrelazB(i - j - 1).Vecinos(k) = 999
                                Exit For
                            End If
                        Next ' fin for 3
                        lBrelazB(i - j - 1).X1 = 999
                        For l = 0 To colores - 1 ' Rehace el siguiente con los valores de los colores
                            lBrelazB(i - j).Vecinos(l) = l
                        Next
                    Next
                    Exit For
                End If
            Next ' fin for 1

            If lBrelazB(boids - 1).X1 <> 999 Then
                Exit While
            End If
            If back >= it Then
                Exit While
            End If
        End While ' fin while

        Return back

    End Function
    Private Function AmigoEnemigo(ByVal lista As String, ByVal pivote As Int16) As String
        Dim i, palabras, pajaro As Int16
        Dim enemigos As String
        enemigos = ""
        palabras = NumWords(lista)

        For i = 0 To palabras - 1
            pajaro = GetWord(lista, i)

            If lBirds(pivote).Vecinos(pajaro) < 0 Then
                If enemigos = "" Then
                    enemigos = pajaro
                Else
                    enemigos = enemigos + " " + CStr(pajaro)
                End If
            End If
        Next

        Return enemigos

    End Function
    Private Function NumWords(ByVal dato As String) As Int16
        Dim i, num As Int16
        num = 1 ' es uno para contar el ltimo
        For i = 1 To Len(dato)
            If Mid(dato, i, 1) = " " Then
                num = num + 1
            End If
        Next
        Return num
    End Function
    Private Function GetWord(ByVal dato As String, ByVal pos As Int16) As String

        Dim i, posi As Int16
        Dim valor As String

        posi = -1 ' es -1 para obtener el primero
        valor = ""

        For i = 1 To Len(dato)
            If Mid(dato, i, 1) <> " " Then
                If valor = "" Then
                    valor = Mid(dato, i, 1)
                Else
                    valor = valor + Mid(dato, i, 1)
                End If
            Else
                posi = posi + 1
                If posi < pos Then
                    valor = ""
                    Continue For
                Else
                    Exit For
                End If
            End If
        Next
        Return valor

    End Function
    Public Function Tabu_Search(ByVal iteratot As Integer, ByVal especial As Int16)
        Dim lprimer, colortabu, itera, newcol, tabu, lmintabu, lmintabu2, salir, i, j, k As Int16
        Dim cadenatabu As String
        Dim cadenachar As Char()
        Dim cambio1, cambio2 As Int16

        ReDim lListaTabu(iteratot)

        lListaTabu(1) = "TS"
        For i = 0 To boids - 1
            lBirds(i).Colour = Random.Next(0, colores)
            lListaTabu(1) = lListaTabu(1) + CStr(lBirds(i).Colour)
        Next

        lmintabu = MinTabu()

        itera = 1
        lprimer = 1

        While True

            itera = itera + 1

            If itera = iteratot Then Exit While

            salir = 0
            tabu = lprimer

            If especial = 1 And ((itera Mod 100) = 0) Then
                cambio1 = Random.Next(0, boids - 1)
                cambio2 = Random.Next(0, boids - 1)
                If cambio1 <> cambio2 Then
                    If lBirds(cambio1).Vecinos(cambio2) < 0 Then
                        lBirds(cambio1).Vecinos(cambio2) = cambio2
                    Else
                        lBirds(cambio1).Vecinos(cambio2) = -999
                    End If
                    For i = 1 To itera
                        cadenachar = lListaTabu(i)
                        If cadenachar.Length = 0 Then
                            Continue For
                        End If
                        cadenachar(cambio1 + 2) = "0"
                        lListaTabu(i) = cadenachar
                    Next
                End If
            End If

            lprimer = ResueltoTabu(tabu)

            If lprimer = tabu Then
                lprimer = lprimer - 1
            End If

            If lprimer = 0 Then Exit While
            colortabu = lBirds(lprimer).Colour

            While True

                For i = 0 To colores - 1
                    salir = salir + 1
                    If i = colortabu Then
                        Continue For
                    End If
                    lBirds(lprimer).Colour = i

                    cadenatabu = "TS"
                    For j = 0 To boids - 1
                        cadenatabu = cadenatabu + CStr(lBirds(j).Colour)
                    Next

                    If EsTabu(cadenatabu, itera) > 0 Then
                        Continue For
                    End If

                    lmintabu2 = MinTabu()
                    If lmintabu2 <= lmintabu Then
                        lmintabu = lmintabu2
                        salir = 32000
                        lListaTabu(itera) = "TS"
                        For k = 0 To boids - 1
                            newcol = lBirds(k).Colour
                            lListaTabu(itera) = lListaTabu(itera) + CStr(newcol)
                        Next
                        Exit While
                    End If
                Next

                If salir >= colores Then
                    lprimer = lprimer - 1
                    If lprimer < 0 Then
                        lprimer = 0
                    End If
                    colortabu = lBirds(lprimer).Colour
                    If salir = 32000 Or lprimer = 2 Then
                        lmintabu = lmintabu2 ' ajusto el algoritmo, esta en un mnimo local
                        Exit While
                    End If
                End If
            End While
        End While

        Return itera

    End Function
    Private Function MinTabu()
        Dim i, j, color, min As Int16

        min = 0

        For i = 0 To (boids - 2)
            color = lBirds(i).Colour
            For j = i + 1 To boids - 1
                If lBirds(i).Vecinos(j) < 0 Then
                    If color = lBirds(j).Colour Then
                        min = min + 1
                    End If
                End If
            Next
        Next
        Return min
    End Function
    Private Function ResueltoTabu(ByVal nodotabu As Int16)
        Dim i, j, color, tabu As Int16

        tabu = 0
        For i = 0 To boids - 2
            color = lBirds(i).Colour
            For j = i + 1 To boids - 1
                If lBirds(i).Vecinos(j) < 0 Then
                    If color = lBirds(j).Colour Then
                        If j = nodotabu Then
                            tabu = 1
                            Continue For
                        End If

                        Return j
                    End If
                End If
            Next
        Next

        If tabu = 0 Then
            Return 0
        Else
            Return nodotabu
        End If
    End Function
    Public Function simulated_anealing(ByVal itera As Integer, ByVal colorsa As Int16, ByRef colorsol As Int16)

        Dim temperatura As Double
        Dim sel, colo, i As Int16
        Dim ener0, ener1 As Integer
        Dim probabilidad0, probabilidad1, lambda As Decimal
        Dim breakwhile As Int16

        temperatura = 0
        ener0 = 0

        For i = 0 To boids - 1
            lBirds(i).Colour = Random.Next(0, colorsa)
            lBirds(i).Stress = lBirds(i).Colour
        Next

        ener0 = Energia(colorsa)

        While True

            If Resuelto() = 0 Then
                If colorsa = colores Then
                    colorsol = 0
                Else
                    colorsol -= 1
                End If
                Exit While
            End If

            temperatura = temperatura + 1

            If temperatura > itera Then
                colorsol = 0
                Exit While
            End If

            breakwhile = 0
            While True
                breakwhile += 1
                If breakwhile > (boids * 10) Then
                    Exit While
                End If
                sel = Random.Next(0, boids)
                If Malcoloreado(sel) = 1 Then
                    Exit While
                End If
            End While

            breakwhile = 0
            While True
                breakwhile += 1
                If breakwhile > (boids * 10) Then
                    Exit While
                End If
                colo = Random.Next(0, colorsa)
                If colo <> lBirds(sel).Colour Then
                    lBirds(sel).Colour = colo
                    Exit While
                End If
            End While

            ener1 = Energia(colorsa)

            If ener1 > ener0 Then
                ener0 = ener1
                For i = 0 To boids - 1
                    lBirds(i).Stress = lBirds(i).Colour
                Next
            Else
                probabilidad0 = (Random.Next(0, 100) / 100)
                If temperatura < 1 Then
                    MessageBox.Show(temperatura)
                End If
                lambda = ((ener0 - ener1) / temperatura) * -1
                probabilidad1 = Math.Exp(lambda)
                If probabilidad0 < probabilidad1 Then
                    ener0 = ener1
                    For i = 0 To boids - 1
                        lBirds(i).Stress = lBirds(i).Colour
                    Next
                End If
            End If
        End While

        Return temperatura

    End Function
    Private Function EsTabu(ByVal cadenatabu As String, ByVal itera As Int16)
        Dim i As Int16
        For i = 0 To itera - 2
            If lListaTabu(i) = cadenatabu Then
                Return 1
            End If
        Next

        Return 0
    End Function
    Private Function Energia(ByVal colores As Int16)
        Dim i, j As Int16
        Dim ener As Integer
        Dim enemigo As Int16

        enemigo = 0
        ener = 0

        For i = 0 To boids - 2
            For j = i + 1 To boids - 1
                If lBirds(i).Colour = lBirds(j).Colour Then
                    If lBirds(i).Vecinos(j) < 0 Then
                        enemigo = 1
                    End If
                    Exit For
                End If
            Next
            If enemigo = 1 Then
                enemigo = 0
            Else
                ener = ener + (boids - colores + 1)
            End If
        Next

        Return ener

    End Function
    Private Function Malcoloreado(ByVal nodo As Int16)
        Dim i, color As Int16

        color = lBirds(nodo).Colour

        For i = 0 To boids - 1
            If i = nodo Then
                Continue For
            End If

            If lBirds(i).Colour = color Then
                If lBirds(i).Vecinos(nodo) < 0 Then
                    Return 1
                End If
            End If
        Next
        Return 0
    End Function
    ' Calculo de cliques metodo Bron-Kerbosch
    Private Function Bronkerbosch(ByVal cliP As String) As String
        Dim i1, i2, i3, i4, i5, i6, i7, i8, pivote As Int16
        Dim pal1, pal2, pal3, pal4, pal5, pal6, pal7, pal8 As Int16
        Dim ene1, ene2, ene3, ene4, ene5, ene6, ene7, ene8 As String
        Dim sal1, sal2, sal3, sal4, sal5, sal6, sal7, sal8, salidaaux As String
        Dim totsal As Int16

        sal1 = 1
        salidaaux = 1

        For i1 = 0 To boids - 1 '1
            ene1 = AmigoEnemigo(cliP, i1)

            totsal = NumWords(salidaaux)
            If totsal < NumWords(sal1) Then
                salidaaux = sal1
            End If

            If ene1 = "" Then
                Continue For
            End If

            pal1 = NumWords(ene1)
            If pal1 <= totsal Then
                Continue For
            End If

            sal1 = CStr(i1)

            For i2 = 0 To pal1 - 1 '2
                pivote = GetWord(ene1, i2)
                sal2 = sal1 + " " + CStr(pivote)
                ene2 = AmigoEnemigo(ene1, pivote)
                If ene2 = "" Then
                    totsal = NumWords(salidaaux)
                    If totsal < NumWords(sal2) Then
                        salidaaux = sal2
                    End If
                    Continue For
                Else
                    pal2 = NumWords(ene2)
                    If pal2 <= (totsal - 1) Then
                        Continue For
                    End If
                    For i3 = 0 To pal2 - 1 '3
                        pivote = GetWord(ene2, i3)
                        sal3 = sal2 + " " + CStr(pivote)
                        ene3 = AmigoEnemigo(ene2, pivote)
                        totsal = NumWords(salidaaux)
                        If totsal < NumWords(sal3) Then
                            salidaaux = sal3
                        End If
                        If ene3 = "" Then
                            Continue For
                        Else
                            pal3 = NumWords(ene3)
                            If pal3 <= (totsal - 2) Then
                                Continue For
                            End If
                            For i4 = 0 To pal3 - 1 '4
                                pivote = GetWord(ene3, i4)
                                sal4 = sal3 + " " + CStr(pivote)
                                ene4 = AmigoEnemigo(ene3, pivote)
                                totsal = NumWords(salidaaux)
                                If totsal < NumWords(sal4) Then
                                    salidaaux = sal4
                                End If
                                If ene4 = "" Then
                                    Continue For
                                Else
                                    pal4 = NumWords(ene4)
                                    If pal4 <= (totsal - 3) Then
                                        Continue For
                                    End If
                                    For i5 = 0 To pal4 - 1 '5
                                        pivote = GetWord(ene4, i5)
                                        sal5 = sal4 + " " + CStr(pivote)
                                        ene5 = AmigoEnemigo(ene4, pivote)
                                        totsal = NumWords(salidaaux)
                                        If totsal < NumWords(sal5) Then
                                            salidaaux = sal5
                                        End If
                                        If ene5 = "" Then
                                            Continue For
                                        Else
                                            pal5 = NumWords(ene5)
                                            If pal5 <= (totsal - 4) Then
                                                Continue For
                                            End If
                                            For i6 = 0 To pal5 - 1 '6
                                                pivote = GetWord(ene5, i6)
                                                sal6 = sal5 + " " + CStr(pivote)
                                                ene6 = AmigoEnemigo(ene5, pivote)
                                                totsal = NumWords(salidaaux)
                                                If totsal < NumWords(sal6) Then
                                                    salidaaux = sal6
                                                End If
                                                If ene6 = "" Then
                                                    Continue For
                                                Else
                                                    pal6 = NumWords(ene6)
                                                    If pal6 <= (totsal - 6) Then
                                                        Continue For
                                                    End If
                                                    For i7 = 0 To pal6 - 1 '7
                                                        pivote = GetWord(ene6, i7)
                                                        sal7 = sal6 + " " + CStr(pivote)
                                                        ene7 = AmigoEnemigo(ene6, pivote)
                                                        totsal = NumWords(salidaaux)
                                                        If totsal < NumWords(sal7) Then
                                                            salidaaux = sal7
                                                        End If
                                                        If ene7 = "" Then
                                                            Continue For
                                                        Else
                                                            pal7 = NumWords(ene7)
                                                            If pal7 <= (totsal - 7) Then
                                                                Continue For
                                                            End If
                                                            For i8 = 0 To pal7 - 1 '8
                                                                pivote = GetWord(ene7, i8)
                                                                sal8 = sal7 + " " + CStr(pivote)
                                                                ene8 = AmigoEnemigo(ene7, pivote)
                                                                totsal = NumWords(salidaaux)
                                                                If totsal < NumWords(sal8) Then
                                                                    salidaaux = sal8
                                                                End If
                                                                If ene8 = "" Then
                                                                    Continue For
                                                                Else
                                                                    pal8 = NumWords(ene8)
                                                                End If
                                                            Next '8
                                                        End If
                                                    Next '7
                                                End If
                                            Next '6
                                        End If
                                    Next '5
                                End If
                            Next '4
                        End If
                    Next '3
                End If
            Next '2
        Next '1

        Return salidaaux

    End Function
    Public Function ParticleSwarmOptimization(ByVal repetir As Int16, ByVal itera As Integer, ByRef tiempo As Integer, ByVal cota As Int16) As Int16

        Dim lArrPSO() As PSO
        Dim i, j, k As Integer
        Dim gbestg, gbesta As Int16
        Dim probg, probx As Decimal

        Dim acierto, fallo As Int16
        Dim inicio As String

        acierto = 0
        fallo = 0
        tiempo = 0

        ReDim lArrPSO(boids)

        inicio = Now

        For k = 1 To repetir

            For i = 0 To boids - 1
                lArrPSO(i).pso_cola = Random.Next(1, colores + 1)
                lArrPSO(i).pso_coll = lArrPSO(i).pso_cola
                lArrPSO(i).pso_colg = lArrPSO(i).pso_cola
            Next

            gbesta = Evaluar_pso(lArrPSO)
            gbestg = gbesta


            For i = 0 To boids - 1
                lArrPSO(i).pso_vall = lArrPSO(i).pso_vala
                'lArrPSO(i).pso_valg = lArrPSO(i).pso_vala
            Next

            j = 0

            While gbestg > 0
                j = j + 1
                If j >= itera Then
                    Exit While
                End If

                gbesta = Evaluar_pso(lArrPSO)
                If gbesta = 0 Then
                    Exit While
                End If

                probx = Random.Next(1, itera - j + 1)
                probx = probx / confort
                probg = Random.Next(1, itera + 1)
                For i = 0 To boids - 1
                    'probx = Random.Next(1, itera - j + 1)
                    'probx = probx / confort
                    'probg = Random.Next(1, itera + 1)
                    If lArrPSO(i).pso_vala > 0 Then
                        If probx <= probg Then
                            lArrPSO(i).pso_cola = Random.Next(1, colores + 1)
                        End If
                    Else
                        If probx >= probg Then
                            lArrPSO(i).pso_cola = Random.Next(1, colores + 1)
                        End If
                    End If
                Next

            End While

            If j >= itera Then
                fallo = fallo + 1
            Else
                acierto = acierto + 1
                FileSystem.WriteLine(1)
                FileSystem.WriteLine(1, "PSO steps: " + CStr(j) + " colors used:" + CStr(colores))
                For i = 0 To boids - 1
                    FileSystem.Print(1, " - " + CStr(lArrPSO(i).pso_cola))
                Next
                If cota < colores Then
                    colores -= 1
                End If
            End If
            tiempo = tiempo + j
        Next

        Return acierto

    End Function
    Private Function Evaluar_pso(ByVal lArrPSO() As PSO) As Int16
        Dim i, j As Int16
        Dim colaux, valor, gbest As Int16

        gbest = 0
        For i = 0 To boids - 1

            colaux = lArrPSO(i).pso_cola
            valor = 0
            For j = i To boids - 1
                If i = j Then
                    Continue For
                End If
                If colaux = lArrPSO(j).pso_cola Then
                    If lBirds(i).Vecinos(j) = -999 Then
                        valor = valor + 1
                    End If
                End If
            Next
            lArrPSO(i).pso_vala = valor
            gbest = gbest + valor
        Next

        Return gbest

    End Function

    Public Function brelaz_algorithm()

        Dim i, j, grado, maxgrado, posi As Int16
        Dim maxdsat1, maxdsat2 As Int16


        'Asignar grados a los nodos
        For i = 0 To boids - 1
            For j = 0 To boids - 1
                If lBirds(i).Vecinos(j) <> 0 Then
                    grado = grado + 1
                End If
            Next
            lBirds(i).Stress = grado
            lBirds(i).Direccion = 0
            lBirds(i).Colour = -1
            grado = 0
        Next

        'Bucar el nodo de mayor grado
        maxgrado = 0
        For i = 0 To boids - 2
            If lBirds(i).Stress < lBirds(i + 1).Stress And maxgrado < lBirds(i + 1).Stress Then
                maxgrado = lBirds(i + 1).Stress
                posi = i + 1
            Else
                If maxgrado < lBirds(i).Stress Then
                    maxgrado = lBirds(i).Stress
                    posi = i
                End If
            End If
        Next
        lBirds(posi).Colour = 0
        recaulculo_dsat()

        ' Recorro el resto de nodos
        For j = 0 To boids - 1

            'Bucar el nodo de mayor grado
            maxgrado = -999
            For i = 0 To boids - 2
                If lBirds(i).Colour >= 0 Then
                    Continue For 'Si ya tiene color lo ingnoro
                End If

                maxdsat1 = lBirds(i).Stress - lBirds(i).Direccion
                maxdsat2 = lBirds(i + 1).Stress - lBirds(i + 1).Direccion

                If maxdsat1 < maxdsat2 And maxgrado < maxdsat2 And lBirds(i + 1).Colour < 0 Then
                    maxgrado = maxdsat2
                    posi = i + 1
                Else
                    If maxgrado < maxdsat1 Then
                        maxgrado = maxdsat1
                        posi = i
                    End If
                End If
            Next
            If maxgrado = -999 Then
                For i = 0 To boids - 1
                    If lBirds(i).Colour < 0 Then
                        posi = i
                        Exit For
                    End If
                Next
            End If

            lBirds(posi).Colour = color_disponible(posi)
            'lBirds(posi).Colour = lBirds(posi).Direccion
            recaulculo_dsat()
        Next

        grado = 0
        For i = 0 To boids - 1
            If lBirds(i).Colour > grado Then
                grado = lBirds(i).Colour
            End If
        Next

        Return grado
    End Function
    Private Sub recaulculo_dsat()
        Dim i, j, grado As Int16

        For i = 0 To boids - 1
            If lBirds(i).Colour >= 0 Then
                Continue For
            End If

            For j = 0 To boids - 1
                If lBirds(i).Vecinos(j) <> 0 Then
                    If lBirds(j).Colour >= 0 Then
                        grado = grado + 1
                    End If
                End If
            Next
            lBirds(i).Direccion = grado
            grado = 0
        Next
    End Sub

    Private Function color_disponible(ByVal boid As Int16)

        Dim i, j, color As Int16
        Dim usado As Int16
        Dim colores As Int16()
        ReDim colores(boids)

        color = 0
        For i = 0 To boids - 1
            If lBirds(boid).Vecinos(i) <> 0 Then
                colores(color) = lBirds(i).Colour
                color = color + 1
            End If
        Next

        For i = 0 To color
            usado = 0
            For j = 0 To color
                If colores(j) = i Then
                    usado = 1
                    Exit For
                End If
            Next
            If usado = 0 Then
                Return i
            End If
        Next

        Return color + 1

    End Function

End Module

